function jaccard = evaluateSegmentation(groundTruthPath, segImgGray, ...
    visualizeFlag)
%EVALUATESEGMENTATION Compute jaccard index for the segmented image
% 
%   Input:
%       groundTruthPath: path to the ground truth segmentation
%       segImgGray     : gray-scale / boolean segmentation output
%       visualizeFlag  : a flag to visualize the segmentation against the
%                        ground truth image
% 
%   Output:
%       jaccard: jaccard index for the segmented image
%
% (c) Moustafa Meshry, moustafa.meshry@alexu.edu.eg
%     Department of Compter and Systems Engineering, Alexandria University, Egypt.

    if (nargin == 2)
        visualizeFlag = false;
    end
    
    gtImg = imread(groundTruthPath);
    
    % note that there are unlabeled pixels (intensity 128), while
    % foreground = 255 and background = 0;
    gtMask = gtImg == 255; 
    unLabeledMask = gtImg == 128;
    % exclude unlabeld pixels from your score calculation
    segImageMask = segImgGray ~= 0;
    segImageMask = segImageMask & ~unLabeledMask;
    
    intersection = segImageMask & gtMask;
    union = segImageMask | gtMask;

    if (visualizeFlag)
        visImage = zeros(size(gtMask));
        visImage(intersection) = 1;
        visImage(xor(union, intersection) & gtMask) = 0.3;
        visImage(xor(union, intersection) & segImageMask) = 0.7;
        imagesc(visImage);
        pause;
    end
    
    jaccard = sum(find(intersection(:))) / sum(find(union(:)));

end

